<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Locations_Hooks_AdSidebarBelowVisitorPanel extends XenCentral_AdServer_Locations_Hooks_Abstract
{
    public function getSubGroup()
    {
        return new XenForo_Phrase('xcas_visitor_sidebar');
    }

    public function getHookName()
    {
        return 'ad_sidebar_below_visitor_panel';
    }

    /**
     * @return String|XenForo_Phrase
     * Title for the location to be used in Admin Panel
     */
    public function getTitle()
    {
        return new XenForo_Phrase('xcas_ad_sidebar_below_visitor_panel');
    }


    /**
     * @return String
     * Returns unique string identified for the location
     */
    public function getLocationId()
    {
        return 'ad_sidebar_below_visitor_panel';
    }

    public function allowChangeModificationMode()
    {
        return false;
    }
}